/******************** (C) COPYRIGHT 2006 STMicroelectronics ********************
* File Name          : main.c
* Author             : MCD Application Team
* Date First Issued  : 11/27/2006  :   Version 1.0
* Description        : main program for Timer to Memory DMA example
********************************************************************************
* History:
* 11/27/2006   :   Version 1.0
********************************************************************************
* THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
* WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
* AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT,
* INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE
* CONTENT OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING
* INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/

/* Includes ------------------------------------------------------------------*/

#include "91x_lib.h"

/* Private typedef -----------------------------------------------------------*/
typedef struct
{
 u32 LLI_SrcAdd;    /* Source address of the data to be transferred.*/

 u32 LLI_DesAdd;    /*Destination address of the data to be transferred.*/

 u32 LLI_Pointer;   /* Pointer to the next LLI. */

 u32 LLI_CCR;   /* the control word. */

} LLI_InitTypeDef;

/* Private variables ---------------------------------------------------------*/
TIM_InitTypeDef   TIM_InitStructure;
DMA_InitTypeDef   DMA_InitStruct;
GPIO_InitTypeDef  GPIO_InitStructure;
u32 TIM_IC1R[7] ={0,0,0,0,0,0,0};/*Buffer to store IC1R values*/
u32 TIM_IC2R[7] ={0,0,0,0,0,0,0};/*Buffer to store IC2R values*/
int j=0;
LLI_InitTypeDef Tab1[6]={0,0,0,0,0,0};
LLI_InitTypeDef Tab2[6]={0,0,0,0,0,0};

/* Private function prototypes -----------------------------------------------*/
void SCU_Configuration(void);
void GPIO_Configuration(void);


void main(void)
{
  #ifdef DEBUG
  debug();
  #endif
 
  /* Configure the system clocks */
  SCU_Configuration();
 
  /* GPIO4 Deinitialization */
  GPIO_DeInit(GPIO4);      
  /* Configure the GPIO ports */
  GPIO_Configuration();
  
  /* TIM0 Deinitialization */
  TIM_DeInit(TIM0);  
  
  /* TIM1 Deinitialization */
  TIM_DeInit(TIM1);    
  
  /***********************Linked list items for Link1*************************/
  for(j = 0; j != 6; j++)
 {
  
  /* Source address for  LLI items of link1*/
  Tab1[j].LLI_SrcAdd=(u32)(&TIM0->IC1R);
  
  /* Destination address  LLI item number "j" of link1*/
  Tab1[j].LLI_DesAdd=(u32)(&TIM_IC1R[j+1]);
  
  /*Control word*/
  Tab1[j].LLI_CCR=0x08480001 ;
 
  /*Pointer to the LLI item number "j+1" of link1*/
  Tab1[j].LLI_Pointer=(u32)(&Tab1[j+1]);
  
 }
 
 /***********************Linked list items for Link2***************************/
  for(j = 0; j != 6; j++)
 {
 
  /* Source address for  LLI items of link2*/
  Tab2[j].LLI_SrcAdd=(u32)(&TIM0->IC2R);
  
  /* Destination address  LLI item number "j" of link2*/
  Tab2[j].LLI_DesAdd=(u32)(&TIM_IC2R[j+1]);
  
  /*Control word*/
  Tab2[j].LLI_CCR=0x08480001 ;
 
  /*Pointer to the LLI item number"j+1" of link2*/
  Tab2[j].LLI_Pointer=(u32)(&Tab2[j+1]);
  
 }
 
  /******************** TIM1 Configuration in PWM Mode ************************/
  TIM_StructInit(&TIM_InitStructure);
  TIM_InitStructure.TIM_Mode = TIM_PWM;    
  TIM_InitStructure.TIM_Clock_Source = TIM_CLK_APB;       
  TIM_InitStructure.TIM_Prescaler = 0x00;       
  TIM_InitStructure.TIM_Pulse_Level_1 = TIM_HIGH;   
  TIM_InitStructure.TIM_Period_Level = TIM_LOW;    
  TIM_InitStructure.TIM_Pulse_Length_1 = 0x1324;  
  TIM_InitStructure.TIM_Full_Period = 0x2648;            
  TIM_Init (TIM1, &TIM_InitStructure);
  TIM_CounterCmd(TIM1, TIM_START);

  /***********************TIM0 Structure PWM input capture*********************/
 
  TIM_StructInit(&TIM_InitStructure);
  TIM_InitStructure.TIM_Mode = TIM_PWMI;
  TIM_InitStructure.TIM_Clock_Source = TIM_CLK_APB;
  TIM_InitStructure.TIM_Prescaler = 0x0;
  TIM_InitStructure.TIM_ICAP1_Edge = TIM_ICAP1_EDGE_RISING;
  TIM_Init (TIM0, &TIM_InitStructure);
    
  /*******************************VIC Configuration****************************/

  VIC_DeInit();
  VIC_Config( TIM1_ITLine  , VIC_IRQ,0);
  VIC_ITCmd( TIM1_ITLine  , ENABLE);  
  
  /*Enable TIM1 output compare interrupt*/
  TIM_ITConfig(TIM1,TIM_IT_OC2, ENABLE);
 
  /***********************************DMA configuration************************/
 
  /* DMA default configuration : Reset configuration*/
  DMA_DeInit(); 
  
  /*Enable the DMA*/
  DMA_Cmd(ENABLE);                 
  DMA_StructInit(&DMA_InitStruct);
  DMA_SyncConfig(DMA_TIM0_Mask, ENABLE);

  /***************************DMA configuration channel0***********************/
  /*pointer to LLI1*/
  DMA_InitStruct.DMA_Channel_LLstItm=(u32)(&( Tab1[0].LLI_SrcAdd)); 
  
  /* source address */
  DMA_InitStruct.DMA_Channel_SrcAdd=(u32)(&TIM0->IC1R); 
 
  /*Destination address for the first LLI structure */
  DMA_InitStruct.DMA_Channel_DesAdd=(u32)(&TIM_IC1R[0]);
  
  /* The source bus width is a word" 32 bits"*/
  DMA_InitStruct.DMA_Channel_SrcWidth= DMA_SrcWidth_Word;
   
  /* The Destination bus width is a word */
  DMA_InitStruct.DMA_Channel_DesWidth= DMA_DesWidth_Word;
  
  /* peripheral to memory transfer*/
  DMA_InitStruct.DMA_Channel_FlowCntrl= DMA_FlowCntrl2_DMA ;
  
  /*source request for TIM0*/
  DMA_InitStruct.DMA_Channel_Src =DMA_SRC_TIM1;
  
  /*transfer size of one byte*/
  DMA_InitStruct.DMA_Channel_TrsfSize =1; 
  
   /*update th DMA channel0 registers*/
  DMA_Init(DMA_Channel0,&DMA_InitStruct);


  /*************************DMA configuration channel1*************************/
  /*pointer to LLI2*/
  DMA_InitStruct.DMA_Channel_LLstItm=(u32)(&(Tab2[0].LLI_SrcAdd)); 
  
  /* source address */
  DMA_InitStruct.DMA_Channel_SrcAdd=(u32)(&TIM0->IC2R); 
  
  /*Destination address for the first LLI structure */
  DMA_InitStruct.DMA_Channel_DesAdd=(u32)(&TIM_IC2R[0]);
  
  /* The source bus width is a word" 32 bits"*/
  DMA_InitStruct.DMA_Channel_SrcWidth= DMA_SrcWidth_Word;
  
  /* The Destination bus width is a word word*/
  DMA_InitStruct.DMA_Channel_DesWidth= DMA_DesWidth_Word; 
  
  /* peripheral to memory transfer*/
  DMA_InitStruct.DMA_Channel_FlowCntrl= DMA_FlowCntrl2_DMA ;
  
  /*source request for TIM0*/
  DMA_InitStruct.DMA_Channel_Src =DMA_SRC_TIM1;
  
  /*transfer size of one byte*/
  DMA_InitStruct.DMA_Channel_TrsfSize =1; 
  
  /*update th DMA channel1 registers*/
  DMA_Init(DMA_Channel1,&DMA_InitStruct); 


  /***********************Enable the timer request to DMA*********************/
  /* Enable the DMA request */
  TIM_DMAConfig(TIM0, TIM_DMA_IC1); 
  
  /* Enable the TIM0 */
  TIM_DMACmd(TIM0, ENABLE); 
  
  /* Start the counter of TIM0 */
  TIM_CounterCmd(TIM0, TIM_START);
  
  /*Enable the DMA channel0*/
  DMA_ChannelCmd (DMA_Channel0,ENABLE); 
  
 /*Enable the DMA channel1*/
  DMA_ChannelCmd (DMA_Channel1,ENABLE);  



while(1);

 }

/*******************************************************************************
* Function Name  : SCU_Configuration
* Description    : Configures the system clocks.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void SCU_Configuration(void)
{

  /* Enable the clock for DMA*/
  SCU_AHBPeriphClockConfig(__DMA,ENABLE); 
  
  /* Enable the clock for VIC*/
  SCU_AHBPeriphClockConfig(__VIC,ENABLE);
  SCU_AHBPeriphReset(__VIC,DISABLE); 
  
   /* Enable the clock for TIM0 and TIM1 */
  SCU_APBPeriphClockConfig(__TIM01, ENABLE); 

  /* Enable the clock for GPIO4 */
  SCU_APBPeriphClockConfig(__GPIO4, ENABLE); 
}

/*******************************************************************************
* Function Name  : GPIO_Configuration
* Description    : Configures the different GPIO ports.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void GPIO_Configuration(void)
{
 
 
  /*GPIO Configuration*/
  /*Pin P4.0 is the input capture Pin */
  GPIO_InitStructure.GPIO_Pin = GPIO_Pin_0;
  GPIO_InitStructure.GPIO_Direction = GPIO_PinInput;
  GPIO_InitStructure.GPIO_Type = GPIO_Type_PushPull;
  GPIO_InitStructure.GPIO_IPConnected = GPIO_IPConnected_Enable;
  GPIO_InitStructure.GPIO_Alternate = GPIO_InputAlt1;
  GPIO_Init(GPIO4,&GPIO_InitStructure);
 
  /*Pin P4.2 is the PWM Pin : the external signal which will be injected into
  Pin P4.2   */
  GPIO_InitStructure.GPIO_Pin = GPIO_Pin_2;
  GPIO_InitStructure.GPIO_Direction = GPIO_PinOutput;
  GPIO_InitStructure.GPIO_Type = GPIO_Type_PushPull;
  GPIO_InitStructure.GPIO_IPConnected = GPIO_IPConnected_Enable;
  GPIO_InitStructure.GPIO_Alternate = GPIO_OutputAlt2;
  GPIO_Init(GPIO4,&GPIO_InitStructure);
  
}

/******************* (C) COPYRIGHT 2006 STMicroelectronics *****END OF FILE****/



